//
//		Definition of the Graphics Manager class
//
//
#ifndef THE_GRAPHICS_MANAGER_H
#define THE_GRAPHICS_MANAGER_H

#include "ldwImage.h"
#include "ldwTiledBackground.h"
//
//
//	UI Color constants

const ldwColor UI_ButtonUpColor(0,0,0);
const ldwColor UI_ButtonOverColor(0x55,0x55,0x55);
const ldwColor UI_ButtonDownColor(0x55,0x55,0x55);
const ldwColor UI_LabelColor(0x45,0x22,00);

const ldwPoint UI_HandCursorHotSpot(21,24);
//

enum EImageType
{
	eImageType_None = -1,

	eImageType_Image,
	eImageType_Strip,
	eImageType_Grid,
};

enum EImage
{
	eImage_None = 0,

	eImage_OpenHand,
	eImage_Hand,

	eImage_MainWideButton,
	eImage_UltraWideButton,
	eImage_MainSceneButton1,
	eImage_MainSceneButton2,
	eImage_MainSceneButton3,
	eImage_MainSceneButton4,
	eImage_MainDetailButton,

	eImage_BoxshotCTButton,	
	eImage_BoxshotHelpButton,
	eImage_BoxshotOptsButton,	
	eImage_BoxshotPlayButton,	
	eImage_BoxshotQuitButton,	
	eImage_BoxshotSOButton,	

	eImage_DialogButton,
	eImage_DialogTilesOrange,	
	eImage_DialogTilesGreen,	

	eImage_LeftArrowButton,
	eImage_RightArrowButton,

	eImage_RadioButtonOff,	
	eImage_RadioButtonOn,	
	eImage_CheckBox,
	eImage_CheckMark,		
	eImage_SliderFrame,		
	eImage_SliderHandle,
	
	eImage_ScrollUpArrow,		
	eImage_ScrollDownArrow,	
	eImage_ScrollVerticalTrack,
	eImage_ScrollVerticalKnob,

	eImage_BamboMeterFrame,
	eImage_StatusBarSliceB,
	eImage_StatusBarSliceR,
	eImage_StatusBulb,
	eImage_MeterSlice,		
	
	eImage_FocusCircle,

	eImage_OverviewBG,
	eImage_AwardsBG,
	eImage_OverviewCloud,

	eImage_LoadingBG,
	eImage_LdwLogo,			
	eImage_Logo,		
	//eImage_BfgLogo,
	eImage_SmallLogo,		

	eImage_IntroPage1,
	eImage_IntroPage2,	
	eImage_IntroPage3,
	eImage_IntroPage4,
	eImage_IntroPage5,
	eImage_IntroPage5Mask,
	eImage_MidGamePage1,
	eImage_MidGamePage1Mask,
	eImage_MidGamePage2,
	eImage_MidGamePage3,
	eImage_MidGamePage3Items,
	eImage_EndGamePage1,
	eImage_EndGamePage1Mask,
	eImage_EndGamePage2,	
	eImage_EndGamePage3,
	eImage_EndGamePage4,

	eImage_MainBG,

	eImage_PuzzlesBG,
	eImage_Help1,		
	eImage_Help2,		
	eImage_Help3,		
	eImage_Help4,		
	eImage_Credits,
	
	eImage_MenuBG,	
	eImage_Empty,			
	
	eImage_ArrowUpGlow,		
	eImage_ArrowDownGlow,	
	eImage_ArrowLeftGlow,	
	eImage_ArrowRightGlow,

	eImage_PuzzleSolved,	
	eImage_PuzzleCover,		
	
	eImage_CollectionBG,
	eImage_CollectingTurtleShells,
	eImage_CollectingCoral,
	eImage_CollectingTablet,
	eImage_CollectingFeathers,
	eImage_CollectingGems,

	eImage_TechBG,			
	eImage_Science,			
	eImage_Medicine,		
	eImage_Alchemy,
	eImage_Restoration,
	eImage_Farming,		
	eImage_Nature,
	eImage_Magic,
	eImage_BuyButton,
	eImage_InfoButton,
	
	eImage_VillagerBG,		
	eImage_BathDamage,
	eImage_BathFilled,

	eImage_HospitalStates,
	
	eImage_FoodBin,
	eImage_Cape,
	eImage_StatueFallen,
	eImage_StatueErect,

	eImage_Waves,
	eImage_YellowSparkle,
	eImage_SparkleStrip2,
	eImage_SparkleStrip,
	eImage_Dust,
	eImage_Algae,
	eImage_Rainbow,
	eImage_Bubble,
	eImage_CandleStrip,
	eImage_Fire,
	eImage_PetalStrip,
	eImage_Waterfall1,
	eImage_Waterfall2,
	eImage_Foam,
	eImage_Carrying,
	eImage_Spray,
	eImage_SharpSparkle,
	eImage_BlurrySparkle,
	eImage_Collectables,
	eImage_Footprints,
	eImage_Raindrops,
	eImage_SmokeStrip,
	eImage_ReefFish1,
	eImage_ReefFish2,
	eImage_ReefFish3,
	eImage_SwarmOfBees,
	eImage_Bubblestrip,

	eImage_AmpPuddle,
	eImage_WoodPile,
	eImage_Scaffolding,
	eImage_GraveStones,

	eImage_FireStrip,		
	eImage_GraveFlowers,

	eImage_FemaleHeads,	
	eImage_FemaleHeadsOld,
	eImage_FemaleBodies,	
	eImage_FemaleActions,	

	eImage_MaleHeads,		
	eImage_MaleHeadsOld,	
	eImage_MaleBodies,	
	eImage_MaleActions,	

	eImage_Ghosts,
	
	eImage_VillagerShadow,
	eImage_Skelly,		
	eImage_Ripple,		
	
	eImage_Sunbeam,		
	eImage_Sundisk,
	
	eImage_Fog,

	eImage_AlchemyLab,		
	eImage_DiskRoomLid,	
	eImage_DiskRoomDoor,
	eImage_DiskRoomDoorFrame,
	eImage_DiskRoomDoorKeys,
	eImage_HerbMagic,			
	eImage_HerbNature,		
	eImage_ScienceLab,		
	eImage_OverhangingTree,

	eImage_AlchemyLab0,
	eImage_AlchemyLab1,
	eImage_AlchemyLab2,
	eImage_AlchemyLab3,
	eImage_AlchemyLab4,	
	
	eImage_HutStates,
	eImage_ClothingHutStates,		

	eImage_OrchardDirtMound,
	eImage_BananaDecals,		
	eImage_MangoDecals,		
	eImage_PapayaDecals,		
	eImage_BananaTreeBare,	
	eImage_MangoTreeBare,		
	eImage_PapayaTreeBare,	

	eImage_RainLift,
	eImage_BrokenRainLift,

	eImage_Bird,			
	eImage_BirdShadow,	

	eImage_Sharks,		

	eImage_Dragonflies,
	eImage_HummingBirds,

	eImage_BathPlans,
	eImage_StatuePlans,
	eImage_RosterBush,
	eImage_Awards,
	
	eImage_NumberOf
};

class theGraphicsManagerImpl;
class ldwGameWindow;

class theGraphicsManager
{
public:

	static theGraphicsManager *Get();
	static void Destroy();

	ldwImage      *GetImage(EImage imageId);
	ldwImageStrip *GetImageStrip(EImage imageId);
	ldwImageGrid  *GetImageGrid(EImage imageId);

	EImageType GetImageType(EImage imageId);
	int GetCellCount(EImage imageId);

	void ReleaseImage(EImage imageId,bool purge = false);

	void Draw(EImage imageId,int x = 0,int y = 0,float alpha = 1.0f,int scale = 100);

	void DrawCell(EImage imageId, int cell, int x = 0, int y = 0,float alpha = 1.0f,int scale = 100);

protected:
	
	static theGraphicsManager *mInstance;

	theGraphicsManager();
	~theGraphicsManager();

	theGraphicsManagerImpl *mGraphicsManager;

	ldwGameWindow *mGameWindow;
};
#endif